rm(list=ls())

library(plotrix) # if necessary, install this package

data = read.csv("time-task-results.csv", sep=",", header=TRUE, strip.white=TRUE)

baseline = data[data$system == "baseline", ]
stivi = data[data$system == "stivi", ]

cube = data[data$tutorial== 1, ]
armchair = data[data$tutorial== 2, ]

baseline.cube = baseline[baseline$tutorial== 1, ]
baseline.armchair = baseline[baseline$tutorial== 2, ]

stivi.cube = stivi[stivi$tutorial== 1, ]
stivi.armchair = stivi[stivi$tutorial== 2, ]

times = c(baseline.cube$time, stivi.cube$time, baseline.armchair$time, stivi.armchair$time)

#######################
# CIs for meadian Cube and Armchair time 
# calculate the medians
ma <- median(cube$time)
mb <- median(armchair$time)

#log-transform the data
logta <- log(cube$time)
logtb <- log(armchair$time)

# Compute the CIs on a logartithmic scale
# Those are CIs of either the mean or the median of the log values
# However, we will treat them as medians
# in order to be able to apply the inverse transformation
lci.a <- t.test(logta)$conf.int
lci.b <- t.test(logtb)$conf.int

# Transform the CIs back to their original scale
ci.a <- exp(lci.a) # 95% CIs of the median of population A
ci.b <- exp(lci.b) # 95% CIs of the median of population B
###############################

# CIs for ratio of median time to compate Baseline with stivi
# calculate the medians
mratio <- median(median(stivi$time)/median(baseline$time))
#log-transform the data
logtbas <- log(baseline$time)
logtext <- log(stivi$time)
# Apply the t.test to find the 95%CI of their mean (and median) difference
lci.diff <- t.test(logtext - logtbas)$conf.int
ci.ratio <- exp(lci.diff) # 95% CIs of their median ratio (rather than difference)
##########################
# Let's first plot the overall time data

col1 = "dodgerblue" # for baseline
col2 = "coral1" # for stivi

# plot the bars and CIs
par(mfrow=c(1,2), mar = c(4,4,1,1), pty='s', cex.main = 1.1)

cbars <- barplot(height = c(ma, mb), ylab = "Median Time (min)",
      ylim = c(0,max(times)), xlim = c(0.5,4), yaxt='n', space=0.7, density = c(50,90), col = c("light gray", "light gray"), border=NA)
par(new=TRUE) #Overlplot individual data points
plot(x=c(rep(0.9,nrow(baseline.cube)), rep(1.5,nrow(stivi.cube)), rep(2.6,nrow(baseline.armchair)), rep(3.2, nrow(stivi.armchair))), 
      y=times, 
      ylab=NA, xlab=NA, xaxt='n', yaxt='n', bty = "n", xlim=c(.5, 4), pch=19, col = c(rep(col1,nrow(baseline.cube)), rep(col2,nrow(stivi.cube)), rep(col1,nrow(baseline.armchair)), rep(col2, nrow(stivi.armchair))), 
      ylim=c(0, max(times)))

axis(1, at = cbars, labels=c("Cube", "Armchair"))
axis(2, at = c(0,10,20,30))

# Creating the error bars (manually by drawing segments)
segments(x0 = cbars, x1 = cbars, y0 = c(ci.a[1], ci.b[1]), y1 = c(ci.a[2], ci.b[2]), lwd = 3)

# plot the CI of the ratio (by using the plotCI function of the plotrix package)
plotCI(0.2, mratio, ui=ci.ratio[2], li=ci.ratio[1], pch=20, xlab=NA, xaxt='n', bty = "n",  
      yaxt='n', ylim=c(.5, 2), ylab="STIVi vs. Baseline", lwd = 3, sfrac = 0, xlim=c(0,1))
segments(0, 1, 0.5, 1, lty=2)
axis(2, at = c(0.5,1,1.5,2))

